/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.peripheral.alternate_dimension;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2839;
import net.minecraft.class_2902;
import net.minecraft.class_3754;
import net.minecraft.class_5138;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import qouteall.imm_ptl.peripheral.alternate_dimension.ChaosBiomeSource;
import qouteall.imm_ptl.peripheral.alternate_dimension.DelegatedChunkGenerator;
import qouteall.imm_ptl.peripheral.alternate_dimension.RegionErrorTerrainGenerator;
import qouteall.q_misc_util.Helper;

public class ErrorTerrainGenerator
extends DelegatedChunkGenerator {
    public static final MapCodec<ErrorTerrainGenerator> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6903.method_46636((class_5321)class_7924.field_41236), (App)class_6903.method_46636((class_5321)class_7924.field_41243)).apply((Applicative)instance, ErrorTerrainGenerator::create));
    public static final int regionChunkNum = 4;
    public static final int averageY = 64;
    public static final int maxY = 128;
    private final class_2680 air = class_2246.field_10124.method_9564();
    private final class_2680 defaultBlock = class_2246.field_10340.method_9564();
    private final class_2680 defaultFluid = class_2246.field_10382.method_9564();
    private final LoadingCache<class_1923, RegionErrorTerrainGenerator> cache = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(30L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<class_1923, RegionErrorTerrainGenerator>(){

        public RegionErrorTerrainGenerator load(class_1923 key) {
            return new RegionErrorTerrainGenerator(key.field_9181, key.field_9180, System.nanoTime());
        }
    });

    public static ErrorTerrainGenerator create(class_7871<class_1959> biomeHolderGetter, class_7871<class_5284> noiseGeneratorSettingsHolderGetter) {
        ChaosBiomeSource chaosBiomeSource = ChaosBiomeSource.createChaosBiomeSource(biomeHolderGetter);
        class_5284 skylandSetting = (class_5284)noiseGeneratorSettingsHolderGetter.method_46747(class_5284.field_26360).comp_349();
        class_3754 islandChunkGenerator = new class_3754((class_1966)chaosBiomeSource, class_6880.method_40223((Object)skylandSetting));
        return new ErrorTerrainGenerator(chaosBiomeSource, (class_2794)islandChunkGenerator);
    }

    public ErrorTerrainGenerator(class_1966 biomeSource, class_2794 delegate) {
        super(biomeSource, delegate);
    }

    @NotNull
    protected MapCodec<? extends class_2794> method_28506() {
        return MAP_CODEC;
    }

    @Override
    @NotNull
    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 randomState, class_5138 structureManager, class_2791 chunkAccess) {
        class_2826[] sectionArray = chunkAccess.method_12006();
        ArrayList<class_2826> locked = new ArrayList<class_2826>();
        for (class_2826 chunkSection : sectionArray) {
            if (chunkSection == null) continue;
            chunkSection.method_16676();
            locked.add(chunkSection);
        }
        return CompletableFuture.supplyAsync(() -> {
            this.doPopulateNoise(chunkAccess);
            return chunkAccess;
        }, class_156.method_18349()).thenApplyAsync(chunkx -> {
            for (class_2826 chunkSection : locked) {
                chunkSection.method_16677();
            }
            return chunkx;
        }, (Executor)class_156.method_18349());
    }

    public void doPopulateNoise(class_2791 chunk) {
        class_2839 protoChunk = (class_2839)chunk;
        class_1923 pos = chunk.method_12004();
        class_2902 oceanFloorHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightMap = protoChunk.method_12032(class_2902.class_2903.field_13194);
        class_2338.class_2339 mutable = new class_2338.class_2339();
        int regionX = Math.floorDiv(pos.field_9181, 4);
        int regionZ = Math.floorDiv(pos.field_9180, 4);
        RegionErrorTerrainGenerator generator = Helper.noError(() -> (RegionErrorTerrainGenerator)this.cache.get((Object)new class_1923(regionX, regionZ)));
        for (int sectionY = 0; sectionY < 16; ++sectionY) {
            class_2826 section = protoChunk.method_38259(sectionY);
            for (int localX = 0; localX < 16; ++localX) {
                for (int localZ = 0; localZ < 16; ++localZ) {
                    for (int localY = 0; localY < 16; ++localY) {
                        int worldX = pos.field_9181 * 16 + localX;
                        int worldY = sectionY * 16 + localY;
                        int worldZ = pos.field_9180 * 16 + localZ;
                        class_2680 currBlockState = generator.getBlockComposition(worldX, worldY, worldZ);
                        if (currBlockState == this.air) continue;
                        section.method_12256(localX, localY, localZ, currBlockState, false);
                        oceanFloorHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                        surfaceHeightMap.method_12597(localX, worldY, localZ, currBlockState);
                    }
                }
            }
        }
    }
}

